/**HEADER********************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved
*
* Copyright (c) 2004-2008 Embedded Access Inc.;
* All Rights Reserved
*
* Copyright (c) 1989-2008 ARC International;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: int_ctrl_fxlc95000.c$
* $Version : 1.0.0.0$
* $Date    : Nov-10-2010$
*
* Comments:
*
*   This file contains definitions for the FXLC95000 interrupt controller
*   functions.
*
*END************************************************************************/

#include "mqx_inc.h"
#include "bsp.h"

static uint_16 irq_levels_sw_stack;



#if 0
/*FUNCTION*-----------------------------------------------------------------
*
* Function Name   : _fxlc95000_int_mask_all_return
* Returned Value  : irq stack level
* Comments        :
*   Mask all interrupts (setting actual int level to 7) and return the irq 
*   stack level.
*
*END*---------------------------------------------------------------------*/

uint_16  _fxlc95000_int_mask_all_return
   (
      void
   )
{ /* Body */
    _fxlc95000_int_mask_all();
    return irq_levels_sw_stack;   
} /* Endbody */



/*FUNCTION*-----------------------------------------------------------------
*
* Function Name   : _fxlc95000_int_restore
* Returned Value  : void
* Comments        :
*   Restore previous sr status.
*
*END*---------------------------------------------------------------------*/

void  _fxlc95000_int_restore
   (
      uint_16 sr_status
   )
{ /* Body */
   _psp_set_sr(0x2700); // Disable interrupt.

  if (sr_status & 0x0700)
    // If restored irq level is non-zero, then make it 7 to prevent nested interrupt.
    sr_status |= 0x0700;

   _psp_set_sr(sr_status);
} /* Endbody */
#endif








/*FUNCTION*-----------------------------------------------------------------
*
* Function Name   : _fxlc95000_int_mask_all
* Returned Value  : void
* Comments        :
*   Mask all interrupts (setting actual int level to 7)
*
*END*---------------------------------------------------------------------*/

void  _fxlc95000_int_mask_all
   (
      void
   )
{ /* Body */
   irq_levels_sw_stack = _psp_get_sr();
   _psp_set_sr(0x2700);
} /* Endbody */

/*FUNCTION*-----------------------------------------------------------------
*
* Function Name   : _fxlc95000_int_unmask_all
* Returned Value  : void
* Comments        :
*   Unmask all interrupts (restoring actual int level from 7)
*
*END*---------------------------------------------------------------------*/

void  _fxlc95000_int_unmask_all
   (
      void
   )
{ /* Body */
   _psp_set_sr(irq_levels_sw_stack);
} /* Endbody */

/* EOF */
